//
//
#include  <stdint.h>

#include  "sta_test.h"


uint16_t    last_test;


static STA_Result_t  sta_start(void)
{
    last_test = 0u;
    return   STA_TEST_PASS;
}


static STA_Result_t  sta_hwbist_micro(void)
{
    last_test = 1u;
    return   STA_TEST_PASS;
}


static STA_Result_t  sta_hwbist_full(void)
{
    last_test = 2u;
    return   STA_TEST_PASS;
}

static STA_Result_t  sta_test_default(void)
{
    last_test = 15u;
    return   STA_TEST_PASS;
}



STA_Result_t    STA_CoreTest(STA_TestType_t item)
{
    STA_Result_t    test_result = STA_TEST_FAIL;

    switch (item)
    {
    case STA_TEST_START:
    	test_result = sta_start();;
        break;

    case STA_HWBIST_MICRO:
    	test_result = sta_hwbist_micro();
        break;

    case STA_HWBIST_FULL:
    	test_result = sta_hwbist_full();
        break;

    case STA_PIE_RAM:
    case STA_PIE_HANDLER:
    case STA_CPU_REG:
    case STA_FPU_REG:
    case STA_VCRC_REG:
    case STA_MARCH:
    case STA_MARCH_COPY:
    case STA_FLASH_CRC:
    case STA_OSC_CT:
    case STA_OSC_HR:
    case STA_TEST_WATCHDOG:
    case STA_TEST_VCRC:
        test_result = sta_test_default();
        break;

    case STA_TEST_END:
        test_result = (last_test > 0u) ? STA_TEST_PASS : STA_TEST_FAIL;
        break;

    case STA_TEST_MAX:
    default:
        //  Unknown: fail test
        break;
    }

    return  test_result;
}
